path = getDirectory("Open sequence of TIFF images");
getFileList(path);

num_images = countTIFFFiles(path); 
run("Image Sequence...", "open=&path number=&num_images starting=1 increment=1 scale=100 file=[] or=[] sort");

title = getTitle();
z = nSlices / num_images;

run("Stack to Hyperstack...", "order=xyczt(default) channels=1 slices=&z frames=&num_images display=Color");
run("3D Viewer");
//call("ij3d.ImageJ3DViewer.setCoordinateSystem", "false");
call("ij3d.ImageJ3DViewer.add", title, "None", "Morpheus 4D Viewer", "0", "true", "true", "true", "2", "0");


function countTIFFFiles(dir) {
   count=0;
   list = getFileList(dir);
   for (i=0; i<list.length; i++) {
      if (endsWith(list[i], ".tif") || endsWith(list[i], ".tiff"))
         print((count++) + ": " + dir + list[i]);
   }
   return count;
}
