path = getDirectory("Open sequence of TIFF images");
getFileList(path);

num_images = countTIFFFiles(path); 
run("Image Sequence...", "open=&path number=&num_images starting=1 increment=1 scale=100 file=[] or=[] convert sort");

title = getTitle();
c = 2;
z = 20;
t = num_images / c;
q = 2;

macro "Morpheus 5DVIew... Tool Options"{
	c = getNumber("Number of Channels:", c);
	z = getNumber("Depth of Z-stack  :", z);
	q = getNumber("Quality (1=best)  :", q);
	t = num_images / c;

	showMessage("Parameters: \n\n Channels: "+c+"\n Z-depth:  "+z+"\n Timepoints: "+t+"\n Quality: "+q);
	
	run("Stack to Hyperstack...", "order=xyzct channels=&c slices=&z frames=&t display=Composite");
	
	run("3D Viewer");
	//call("ij3d.ImageJ3DViewer.setCoordinateSystem", "false");
	call("ij3d.ImageJ3DViewer.add", title, "None", "Morpheus 5D Viewer", "0", "true", "true", "true", q, "0");

}


function countTIFFFiles(dir) {
   count=0;
   list = getFileList(dir);
   for (i=0; i<list.length; i++) {
      if (endsWith(list[i], ".tif") || endsWith(list[i], ".tiff"))
         print((count++) + ": " + dir + list[i]);
   }
   return count;
}


